#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;
using ll = long long;

struct point {
    ll x, y;
};
point operator-(point a, point b) {
    return {a.x-b.x, a.y-b.y};
}
ll operator%(point a, point b) {
    return a.x*b.y - a.y*b.x;
}
ll quadrant(point a) {
	ll res = 0;
	while (!(a.x > 0 && a.y >= 0)) {
		a = {a.y,-a.x};
		res++;
	}
	return res;
}
bool operator<(point a, point b) {
	ll qa = quadrant(a), qb = quadrant(b);
	if (qa != qb) return qa < qb;
	if (ll cross = a % b) return cross > 0;
	return abs(a.x)+abs(a.y) < abs(b.x)+abs(b.y);
}

ll T, N;
vector<point> a, b;

int main() {
	ios_base::sync_with_stdio(false);	
	for (cin >> T; T--;) {
		cin >> N;
		a.resize(N);
        for (int i = 0; i < N; ++i)
		    cin >> a[i].x >> a[i].y;

		b.resize(N - 1);
		for (int i = 0; i + 1 < N; ++i)
            b[i] = a[i+1] - a[i];
		sort(b.begin(), b.end());

		bool res = (N == 2);
        for (int i = 0; i + 1 < N; ++i) {
			point p = b[i];
            point q = b[(i + 1) % (N - 1)];
			if (p % q < 0)
                res = true;
		}
		cout << (res ? "IGEN" : "NEM") << "\n";
	}
    return 0;
}
