#include <iostream>
#include <vector>
#include <queue>

using namespace std;

const int N = 200005;
int n, m;
vector<int> ls[N], topo;
int in[N], vis[N];
queue<int> Q;

void dfs(int node) {
    if (vis[node] == 1) {
        printf("-1\n");
        exit(0);
    }
    if (vis[node] == 2)
        return;
    vis[node] = 1;
    for (int x:ls[node])
        dfs(x);
    vis[node] = 2;
}
int main() {
    ios::sync_with_stdio(false);
    cin >> n >> m;
    for (int i = 0; i < m; ++i) {
        int a, b;
        cin >> a >> b;
        ls[a].push_back(b);
        in[b]++;
    }
    for (int i=1; i<=n; ++i) {
        if (!vis[i])
            dfs(i);
        if (in[i] == 0)
            Q.push(i);
    }
    while (!Q.empty()) {
        int node = Q.front();
        Q.pop();
        topo.push_back(node);
        for (int sus : ls[node]) {
            in[sus]--;
            if (in[sus] == 0)
                Q.push(sus);
        }
    }
    cout << topo.size() << "\n";
    for (int x : topo)
        cout << x << " 0\n";

    return 0;
}
